/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.security.acl.AclEnumerator;
import sun.security.acl.OwnerImpl;

public class AclImpl
extends OwnerImpl
implements Acl {
    private Hashtable<Principal, AclEntry> allowedUsersTable = new Hashtable(23);
    private Hashtable<Principal, AclEntry> allowedGroupsTable = new Hashtable(23);
    private Hashtable<Principal, AclEntry> deniedUsersTable = new Hashtable(23);
    private Hashtable<Principal, AclEntry> deniedGroupsTable = new Hashtable(23);
    private String aclName = null;
    private Vector<Permission> zeroSet = new Vector(1, 1);

    public AclImpl(Principal principal, String string) {
        super(principal);
        try {
            this.setName(principal, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.aclName = string;
    }

    public String getName() {
        return this.aclName;
    }

    public synchronized boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        Hashtable<Principal, AclEntry> hashtable = this.findTable(aclEntry);
        if (hashtable.get(principal2 = aclEntry.getPrincipal()) != null) {
            return false;
        }
        hashtable.put(principal2, aclEntry);
        return true;
    }

    public synchronized boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        Hashtable<Principal, AclEntry> hashtable = this.findTable(aclEntry);
        AclEntry aclEntry2 = hashtable.remove(principal2 = aclEntry.getPrincipal());
        return aclEntry2 != null;
    }

    public synchronized Enumeration<Permission> getPermissions(Principal principal) {
        Enumeration<Permission> enumeration = this.subtract(this.getGroupPositive(principal), this.getGroupNegative(principal));
        Enumeration<Permission> enumeration2 = this.subtract(this.getGroupNegative(principal), this.getGroupPositive(principal));
        Enumeration<Permission> enumeration3 = this.subtract(this.getIndividualPositive(principal), this.getIndividualNegative(principal));
        Enumeration<Permission> enumeration4 = this.subtract(this.getIndividualNegative(principal), this.getIndividualPositive(principal));
        Enumeration<Permission> enumeration5 = this.subtract(enumeration, enumeration4);
        Enumeration<Permission> enumeration6 = AclImpl.union(enumeration3, enumeration5);
        enumeration3 = this.subtract(this.getIndividualPositive(principal), this.getIndividualNegative(principal));
        enumeration4 = this.subtract(this.getIndividualNegative(principal), this.getIndividualPositive(principal));
        enumeration5 = this.subtract(enumeration2, enumeration3);
        Enumeration<Permission> enumeration7 = AclImpl.union(enumeration4, enumeration5);
        return this.subtract(enumeration6, enumeration7);
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        Enumeration<Permission> enumeration = this.getPermissions(principal);
        while (enumeration.hasMoreElements()) {
            Permission permission2 = enumeration.nextElement();
            if (!permission2.equals((Object)permission)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration<AclEntry> entries() {
        return new AclEnumerator(this, this.allowedUsersTable, this.allowedGroupsTable, this.deniedUsersTable, this.deniedGroupsTable);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<AclEntry> enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = enumeration.nextElement();
            stringBuffer.append(aclEntry.toString().trim());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private Hashtable<Principal, AclEntry> findTable(AclEntry aclEntry) {
        Hashtable<Principal, AclEntry> hashtable = null;
        Principal principal = aclEntry.getPrincipal();
        hashtable = principal instanceof Group ? (aclEntry.isNegative() ? this.deniedGroupsTable : this.allowedGroupsTable) : (aclEntry.isNegative() ? this.deniedUsersTable : this.allowedUsersTable);
        return hashtable;
    }

    private static Enumeration<Permission> union(Enumeration<Permission> enumeration, Enumeration<Permission> enumeration2) {
        Vector<Permission> vector = new Vector<Permission>(20, 20);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            Permission permission = enumeration2.nextElement();
            if (vector.contains(permission)) continue;
            vector.addElement(permission);
        }
        return vector.elements();
    }

    private Enumeration<Permission> subtract(Enumeration<Permission> enumeration, Enumeration<Permission> enumeration2) {
        Vector<Permission> vector = new Vector<Permission>(20, 20);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            Permission permission = enumeration2.nextElement();
            if (!vector.contains(permission)) continue;
            vector.removeElement(permission);
        }
        return vector.elements();
    }

    private Enumeration<Permission> getGroupPositive(Principal principal) {
        Enumeration<Permission> enumeration = this.zeroSet.elements();
        Enumeration<Principal> enumeration2 = this.allowedGroupsTable.keys();
        while (enumeration2.hasMoreElements()) {
            Group group = (Group)enumeration2.nextElement();
            if (!group.isMember(principal)) continue;
            AclEntry aclEntry = this.allowedGroupsTable.get(group);
            enumeration = AclImpl.union(aclEntry.permissions(), enumeration);
        }
        return enumeration;
    }

    private Enumeration<Permission> getGroupNegative(Principal principal) {
        Enumeration<Permission> enumeration = this.zeroSet.elements();
        Enumeration<Principal> enumeration2 = this.deniedGroupsTable.keys();
        while (enumeration2.hasMoreElements()) {
            Group group = (Group)enumeration2.nextElement();
            if (!group.isMember(principal)) continue;
            AclEntry aclEntry = this.deniedGroupsTable.get(group);
            enumeration = AclImpl.union(aclEntry.permissions(), enumeration);
        }
        return enumeration;
    }

    private Enumeration<Permission> getIndividualPositive(Principal principal) {
        Enumeration enumeration = this.zeroSet.elements();
        AclEntry aclEntry = this.allowedUsersTable.get(principal);
        if (aclEntry != null) {
            enumeration = aclEntry.permissions();
        }
        return enumeration;
    }

    private Enumeration<Permission> getIndividualNegative(Principal principal) {
        Enumeration enumeration = this.zeroSet.elements();
        AclEntry aclEntry = this.deniedUsersTable.get(principal);
        if (aclEntry != null) {
            enumeration = aclEntry.permissions();
        }
        return enumeration;
    }
}

